﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="VIRP_WEB.Controls.Custom.BPR.controls_UserControlDeploymentHistory" Codebehind="UserControlDeploymentHistory.ascx.cs" %>
<%@ Register Src="BaseControlLabel.ascx" TagName="BaseControlLabel" TagPrefix="UserControl" %>
<script type="text/javascript">
    $(document).ready(function () {

        if ($('#<%= CheckBoxDeploymentHistory.ClientID %>').is(':checked')) {
            $('#<%= PanelDeploymentHistory.ClientID %>').show();
    }
    else {
        $('#<%=  PanelDeploymentHistory.ClientID %>').hide();
    }

        $('#<%= CheckBoxDeploymentHistory.ClientID %>').change(function () {
            if (this.checked) {
                $('#<%= PanelDeploymentHistory.ClientID %>').show();
        }
        else {
            $('#<%= PanelDeploymentHistory.ClientID %>').hide();
        }
    });

    });
</script>

<asp:Panel ID="PanelEligibleDeployment" runat="server" GroupingText=" Eligible Deployments " role="heading" aria-level="3" >
    <asp:GridView
        ID="GridViewEligibleDeployments"
        runat="server"
        Caption="Eligible Deployments"
        AutoGenerateColumns="False"
        DataSourceID="DataSourceEligibleDeployments"
        EnableModelValidation="True"
        DataKeyNames="REGISTRANT_DEPLOYMENT_ID"
        >
        <EmptyDataTemplate>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp No deployment history found. &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</EmptyDataTemplate>
        <Columns>
            <asp:TemplateField HeaderText="ID" AccessibleHeaderText="ID" Visible="false">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelDeploymentId" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("REGISTRANT_DEPLOYMENT_ID")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="Begin" SortExpression="DEPLOYMENT_START_DATE">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelBegin" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("DeploymentStartDate")).Length > 0 ? Convert.ToDateTime(Helpers.AhobprEval(Eval("DeploymentStartDate"))).ToString("MM/dd/yyyy") : string.Empty %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="End" SortExpression="DEPLOYMENT_END_DATE">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelEnd" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("DeploymentEndDate")).Length > 0 ? Convert.ToDateTime(Helpers.AhobprEval(Eval("DeploymentEndDate"))).ToString("MM/dd/yyyy") : string.Empty %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="Conflict" SortExpression="DUTY_PROJECT_CODE">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelConflict" SkinID="DataLabel" runat="server" Text='<%# Helpers.AhobprEval(Eval("DUTY_PROJECT_CODE"))  %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="Location" SortExpression="DEPLOYMENT_COUNTRY">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelLocation" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("DEPLOYMENT_COUNTRY")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>


            <asp:TemplateField HeaderText="Branch" SortExpression="STD_BRANCH_OF_SERVICE.BRANCH_OF_SERVICE">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelBranch" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("STD_BRANCH_OF_SERVICE.BRANCH_OF_SERVICE")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="Unit Component" SortExpression="DEPLOYMENT_UIC">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelUnitComponent" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("UnitComponent")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="Rank" SortExpression="MILITARY_RANK">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelRank" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("MILITARY_RANK")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="MOS" SortExpression="STD_SERVICE_OCCUPATION_ID">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelMOS" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("ServiceOccupation")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>


            <asp:TemplateField HeaderText="Data Source">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelDataSource" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("DataSource")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>



            <asp:TemplateField HeaderText="Deployment Stage">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelDeploymentStage" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("DeploymentStage")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
          
            <asp:ButtonField ButtonType="Button" Text="Select" CommandName="Details" ValidationGroup="SearchRegistrant"
                ItemStyle-VerticalAlign="Middle" ItemStyle-HorizontalAlign="Center" AccessibleHeaderText="Select" Visible="false" />
        </Columns>
    </asp:GridView>
    <asp:ObjectDataSource
        ID="DataSourceEligibleDeployments" runat="server"
        SelectMethod="SelectRegistrantEligibleDeployments"
        SelectCountMethod="EligibleDeploymentCount"
        StartRowIndexParameterName="startRow"
        MaximumRowsParameterName="maxRows"
        SortParameterName="sort"
        EnablePaging="True"
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRRegistrantManager">
        <SelectParameters>
            <asp:ControlParameter ControlID="HiddenFieldRegistrantId" Name="registrantId" PropertyName="Value" Type="String" />
            <asp:Parameter Name="sort" Type="String" />
            <asp:Parameter Name="startRow" Type="Int32" />
            <asp:Parameter Name="maxRows" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Panel>
<br />
<asp:CheckBox ID="CheckBoxDeploymentHistory" runat="server" Text="View Deployment History" Font-Bold="true" Checked="false"
    ToolTip="Select this checkbox to show Deployment History" />
<asp:Panel ID="PanelDeploymentHistory" runat="server" GroupingText=" Deployment History ">
    <asp:GridView
        ID="GridViewDeploymentHistory"
        runat="server"
        Caption="Deployment History"
        AutoGenerateColumns="False"
        DataSourceID="DataSourceDeploymentHistory"
        EnableModelValidation="True"
        AllowPaging="True"
        AllowSorting="True"
        OnPageIndexChanging="gridView_PageIndexChanging"
        DataKeyNames="REGISTRANT_DEPLOYMENT_ID">
        <EmptyDataTemplate>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp No deployment history found. &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</EmptyDataTemplate>
        <Columns>
            <asp:TemplateField HeaderText="ID" AccessibleHeaderText="ID" Visible="false">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelDeploymentId" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("REGISTRANT_DEPLOYMENT_ID")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="Begin" SortExpression="DEPLOYMENT_START_DATE">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelBegin" runat="server" SkinID="DataLabel" Text='<%# Convert.ToDateTime(Helpers.AhobprEval(Eval("DeploymentStartDate"))).ToString("MM/dd/yyyy") %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="End" SortExpression="DEPLOYMENT_END_DATE">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelEnd" runat="server" SkinID="DataLabel" Text='<%# Convert.ToDateTime(Helpers.AhobprEval(Eval("DeploymentEndDate"))).ToString("MM/dd/yyyy") %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="Conflict" SortExpression="DUTY_PROJECT_CODE">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelConflict" SkinID="DataLabel" runat="server" Text='<%# Helpers.AhobprEval(Eval("DUTY_PROJECT_CODE"))  %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="Location" SortExpression="DEPLOYMENT_COUNTRY">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelLocation" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("DEPLOYMENT_COUNTRY")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>


            <asp:TemplateField HeaderText="Branch" SortExpression="STD_BRANCH_OF_SERVICE.BRANCH_OF_SERVICE">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelBranch" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("STD_BRANCH_OF_SERVICE.BRANCH_OF_SERVICE")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="Unit Component" SortExpression="DEPLOYMENT_UIC">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelUnitComponent" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("UnitComponent")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="Rank" SortExpression="MILITARY_RANK">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelRank" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("MILITARY_RANK")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:TemplateField HeaderText="MOS" SortExpression="STD_SERVICE_OCCUPATION_ID">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelMOS" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("ServiceOccupation")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>


            <asp:TemplateField HeaderText="Data Source">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelDataSource" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("DataSource")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>


            <asp:TemplateField HeaderText="Deployment Stage">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelDeploymentStage" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("DeploymentStage")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>

            <asp:ButtonField ButtonType="Button" Text="Select" CommandName="Details" ValidationGroup="SearchRegistrant"
                ItemStyle-VerticalAlign="Middle" ItemStyle-HorizontalAlign="Center" AccessibleHeaderText="Select" Visible="false" />
        </Columns>
    </asp:GridView>
    <asp:ObjectDataSource
        ID="DataSourceDeploymentHistory" runat="server"
        SelectMethod="SelectRegistrantDeploymentHistory"
        SelectCountMethod="DeploymentCount"
        StartRowIndexParameterName="startRow"
        MaximumRowsParameterName="maxRows"
        SortParameterName="sort"
        EnablePaging="True"
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRRegistrantManager">
        <SelectParameters>
            <asp:ControlParameter ControlID="HiddenFieldRegistrantId" Name="registrantId" PropertyName="Value" Type="String" />
            <asp:Parameter Name="sort" Type="String" />
            <asp:Parameter Name="startRow" Type="Int32" />
            <asp:Parameter Name="maxRows" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Panel>
<asp:HiddenField ID="HiddenFieldRegistrantId" runat="server" />
